<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;

/**
 * AccountChange
 *
 * @ORM\Table(name="account_changes")
 * @ORM\Entity
 *
 * @ORM\HasLifecycleCallbacks
 *
 * @ExclusionPolicy("all")
 */
class AccountChange
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"details","list"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_bank_service_option_id", type="integer")
     */
    private $companyBankServiceOptionId;

    /**
     * @var integer
     *
     * @ORM\Column(name="round_id", type="integer")
     */
    private $roundId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="create_at", type="datetime")
     *
     * @Expose
     * @AnnotationGroups({"details","list"})
     * @Type("DateTime<'Y-m-d H:i:s'>")
     */
    private $createAt;

    /**
     * @var float
     *
     * @ORM\Column(name="value", type="decimal", precision=13, scale=2)
     *
     * @Expose
     * @AnnotationGroups({"details","list"})
     */
    private $value;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"details","list"})
     */
    private $description = '';


    /**
     * @ORM\ManyToOne(targetEntity="CompanyBankServiceOption", inversedBy="accountChanges")
     * @ORM\JoinColumn(name="company_bank_service_option_id", referencedColumnName="id")
     */
    protected $companyBankServiceOption;

    /**
     * @ORM\ManyToOne(targetEntity="Round", inversedBy="accountChanges")
     * @ORM\JoinColumn(name="round_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"details","list"})
     */
    protected $round;


    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set companyBankServiceOptionId
     *
     * @param integer $companyBankServiceOptionId
     * @return AccountChange
     */
    public function setCompanyBankServiceOptionId($companyBankServiceOptionId)
    {
        $this->companyBankServiceOptionId = $companyBankServiceOptionId;
    
        return $this;
    }

    /**
     * Get companyBankServiceOptionId
     *
     * @return integer 
     */
    public function getCompanyBankServiceOptionId()
    {
        return $this->companyBankServiceOptionId;
    }

    /**
     * Set roundId
     *
     * @param integer $roundId
     * @return AccountChange
     */
    public function setRoundId($roundId)
    {
        $this->roundId = $roundId;
    
        return $this;
    }

    /**
     * Get roundId
     *
     * @return integer 
     */
    public function getRoundId()
    {
        return $this->roundId;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return AccountChange
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set value
     *
     * @param float $value
     * @return AccountChange
     */
    public function setValue($value)
    {
        $this->value = $value;
    
        return $this;
    }

    /**
     * Get value
     *
     * @return float 
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return AccountChange
     */
    public function setDescription($description)
    {
        $this->description = $description;
    
        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set companyBankServiceOption
     *
     * @param \VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOption
     * @return AccountChange
     */
    public function setCompanyBankServiceOption(\VM\ApiBundle\Entity\CompanyBankServiceOption $companyBankServiceOption = null)
    {
        $this->companyBankServiceOption = $companyBankServiceOption;
    
        return $this;
    }

    /**
     * Get companyBankServiceOption
     *
     * @return \VM\ApiBundle\Entity\CompanyBankServiceOption 
     */
    public function getCompanyBankServiceOption()
    {
        return $this->companyBankServiceOption;
    }

    /**
     * Set round
     *
     * @param \VM\ApiBundle\Entity\Round $round
     * @return AccountChange
     */
    public function setRound(\VM\ApiBundle\Entity\Round $round = null)
    {
        $this->round = $round;
    
        return $this;
    }

    /**
     * Get round
     *
     * @return \VM\ApiBundle\Entity\Round 
     */
    public function getRound()
    {
        return $this->round;
    }
}